/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.table;

import filenet.vw.api.VWDataField;
import filenet.vw.api.VWSchema;
import filenet.vw.api.VWXMLData;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWWebServiceUtils;
import filenet.vw.toolkit.utils.VWStringUtils;

public class VWFieldDataForTable {
    private String m_fieldName = null;
    private int m_type;
    private boolean m_bArray = false;
    private Object m_value = null;
    private boolean m_bReadOnly = false;
    private Object m_sampleValue = null;
    private VWSchema m_vwSchema = null;
    private VWWebServiceUtils m_wsUtils = null;

    public VWFieldDataForTable(int type, boolean bArray, Object value, String fieldName) {
        this.m_fieldName = fieldName;
        this.m_bArray = bArray;
        this.m_type = type;
        this.m_value = value;
    }

    public VWFieldDataForTable(int type, boolean bArray, Object value, String fieldName, boolean readOnly) {
        this.m_fieldName = fieldName;
        this.m_bArray = bArray;
        this.m_type = type;
        this.m_value = value;
        this.m_bReadOnly = readOnly;
    }

    public VWFieldDataForTable(VWDataField vwData) {
        try {
            this.m_fieldName = vwData.getName();
            this.m_bArray = vwData.isArray();
            this.m_type = vwData.getFieldType();
            this.m_value = vwData.getValue();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWFieldDataForTable(int type, boolean bArray, Object value, String fieldName, Object sampleValue) {
        this.m_type = type;
        this.m_bArray = bArray;
        this.m_value = value;
        this.m_fieldName = fieldName;
        this.m_sampleValue = sampleValue;
    }

    public VWFieldDataForTable(int type, boolean bArray, Object value, String fieldName, VWSchema vwSchema, VWWebServiceUtils wsUtils) {
        this.m_type = type;
        this.m_bArray = bArray;
        this.m_value = value;
        this.m_fieldName = fieldName;
        this.m_vwSchema = vwSchema;
        this.m_wsUtils = wsUtils;
    }

    public String getFieldName() {
        return this.m_fieldName;
    }

    public int getType() {
        return this.m_type;
    }

    public boolean isArray() {
        return this.m_bArray;
    }

    public Object getValue() {
        return this.m_value;
    }

    public boolean getReadOnly() {
        return this.m_bReadOnly;
    }

    public Object getSampleValue() {
        if (this.m_sampleValue == null && this.m_value != null) {
            if (this.m_value instanceof VWXMLData) {
                String xmlValue = ((VWXMLData)this.m_value).getXML();
                if (xmlValue == null || xmlValue.length() <= 2) {
                    return this.getSampleXMLValue((VWXMLData)this.m_value);
                }
            } else if (this.m_value instanceof VWXMLData[] && ((VWXMLData[])this.m_value).length > 0) {
                return this.getSampleXMLValue(((VWXMLData[])this.m_value)[0]);
            }
        }
        return this.m_sampleValue;
    }

    private String getSampleXMLValue(VWXMLData xmlData) {
        try {
            if (xmlData != null && this.m_vwSchema != null && this.m_wsUtils != null) {
                String schema;
                String schemaFieldName = xmlData.getSchemaName();
                String elementName = xmlData.getElementName();
                if (schemaFieldName != null && elementName != null && (schema = this.m_vwSchema.getSchema()) != null && schema.length() > 0) {
                    String xmlString = this.m_wsUtils.getXMLTemplate(schemaFieldName, schema, elementName);
                    if (xmlString != null && xmlString.length() > 0) {
                        xmlString = VWStringUtils.replaceAll(xmlString, "\"", "\"\"");
                    }
                    return xmlString;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

